function TUMi = TU(i,Mi)

% Computes TU(Mi) given (i,Mi).

%-------
% setup
%-------

% global

global beta plr Pr_data x_data n NA NY NW jstate

% allocate memory

TUMi(NW(i)) = struct;

%-------------
% computation
%-------------

% get TMi

TMi = T(i,Mi);

% compute TU(Mi)

for wi=1:NW(i)
    
  ext_cand = [];
  
  % compute ext_cand: list up all ext points of TMi and Mi
  
  if (TMi(wi).emp==0)
    ext_cand = [ext_cand; TMi(wi).ext];
  end
  
  if (Mi(wi).emp==0)
    ext_cand = [ext_cand; Mi(wi).ext];
  end

  % reduce to TUMi(wip)
    
  if (size(ext_cand,1)==0)
    TUMi(wi).emp = 1;
    TUMi(wi).ext = NaN;
  else
    TUMi(wi).emp = 0;
    TUMi(wi).ext = extblfs(ext_cand);
  end 

end
